set echo off
set feedback off
set linesize 512

prompt
prompt All Clusters in Database
prompt

column tab_column_name format a32
break on OWNER skip 1 on TABLESPACE_NAME on CLUSTER_NAME on TABLE_NAME

SELECT	 A.OWNER, A.TABLESPACE_NAME, A.CLUSTER_NAME, B.TABLE_NAME,
		 B.TAB_COLUMN_NAME, B.CLU_COLUMN_NAME, A.CLUSTER_TYPE,
		 A.AVG_BLOCKS_PER_KEY, A.KEY_SIZE, A.FUNCTION, A.HASHKEYS, A.PCT_FREE,
		 A.PCT_USED, A.INI_TRANS, A.MAX_TRANS, A.INITIAL_EXTENT, A.NEXT_EXTENT,
		 A.MIN_EXTENTS, A.MAX_EXTENTS, A.PCT_INCREASE
	FROM DBA_CLUSTERS A, DBA_CLU_COLUMNS B
   WHERE A.OWNER = B.OWNER
	 AND A.CLUSTER_NAME = B.CLUSTER_NAME
         AND A.OWNER NOT IN ('SYS','SYSTEM','OUTLN','DBSNMP')
ORDER BY 1, 2, 3, 4;